/*
 * unsplit.c -- filter for re-combining continuation lines 
 */
/*
 * $Id: unsplit.c,v 1.3 2000/02/02 23:57:39 mpc Exp $ 
 */

/* copyright.h */
/* -*-C-*- */
/* $Id: unsplit.c,v 1.3 2000/02/02 23:57:39 mpc Exp $ */

/*
 * TinyMUX 1.0, 1.1 and 1.2 Source code is maintained by David Passmore
 * (Lauren@Children of the Atom).
 * Comments should be sent to lauren@ranger.range.orst.edu.
 * TinyMUX is Copyright (c) 1995 by David Passmore.
 *
 * Many parts of the source code, and the help text were derived from
 * TinyMUSH 2.2:
 * TinyMUSH 2.2 Source was written in part by
 *     Jean Marie Diaz, Lydia Leong, and Devin Hooker
 *     2.2 initial alpha release 9/21/94.
 *         final beta snapshot (hopefully) 3/4/95
 *
 * Many parts of the source code, and the help text were derived from
 * PennMUSH 1.50:
 *
 * Patchlevel 12 is based on PennMUSH pl10, the last version of PennMUSH
 * released by Amberyl. All copyright notices above continue to apply.
 * Versions of PennMUSH prior to pl10 are written in part by
 *      Alan Schwartz
 * Thanks and praise are due to:
 * Ralph Melton (Rhyanna@Castle D'Image) for bugs reports, patches, ideas,
 *    and extensions
 * T. Alexander Popiel for bug reports, patches, ideas, and extensions, too.
 * Al Brown (Kalkin@DarkZone) for many clever ideas
 * The many other people who've sent in bug reports
 * The admin and players of Dune II, who put up with a lot of broken code
 * Special thanks to Amberyl for all her help.
 *      - Paul/Javelin (Alan Schwartz, alansz@mellers1.psych.berkeley.edu)
 *
 * Based on TinyMUSH 2.0 Source code
 * Copyright (c) 1991 Joseph Traub and Glenn Crocker
 *
 * Based on TinyMUD code
 * Copyright (c) 1989, 1990 by David Applegate, James Aspnes, Timothy Freeman,
 *                             and Bennet Yee.
 *
 * This material was developed by the above-mentioned authors.  Permission to
 * copy this software, to redistribute it, and to use it for any purpose is
 * granted, subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice in
 *    full.
 *
 * 2. Users of this software agree to make their best efforts
 *    (a) to return to the above-mentioned authors any improvements or
 *        extensions that they make, so that these may be included in future
 *        releases; and
 *    (b) to inform the authors of noteworthy uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this software
 *    shall duly acknowledge such use, in accordance with the usual standards
 *    of acknowledging credit in academic research.
 *
 * 4. The authors have made no warrantee or representation that the operation
 *    of this software will be error-free, and the authors are under no
 *    obligation to provide any services, by way of maintenance, update, or
 *    otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 *    there shall be no use of the names of the authors, of Carnegie-Mellon
 *    University, nor of any adaptation thereof in any advertising,
 *    promotional, or sales literature without prior written consent from
 *    the authors and both Carnegie-Mellon University Case Wester Reserve
 *    University in each case.
 *
 * Credits:
 *    Lawrence Foard:
 *      Wrote the original TinyMUSH 1.0 code from which this later derived.
 *    Jin (and MicroMUSH):
 *      Made many, many changes to the code that improved it immensely.
 *    Lachesis:
 *      Introduced the idea of property lists to TinyMUCK
 *    Many others:
 *      Many features borrowed from other muds.
 */

#include <stdio.h>
#include <ctype.h>

int main(argc, argv)
int argc;
char **argv;
{
	int c, numcr;

	while ((c = getchar()) != EOF) {
		if (c == '\\') {
			numcr = 0;
			do {
				c = getchar();
				if (c == '\n')
					numcr++;
			} while ((c != EOF) && isspace(c));
			if (numcr > 1)
				putchar('\n');
			ungetc(c, stdin);
		} else {
			putchar(c);
		}
	}
	fflush(stdout);
	exit(0);
}
