/* v1.1
 *
 * rxl.c:  Range Translation interface routines.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include <assert.h>
#include "spaceconf.h"
#include "pseint.h"
#include "dbint.h"
#include "space.h"

/* Include the core translation definitions for the plugin interface */
#include "rxl/rxl.h"

/* Include the interface structure definitions 
 *
 * extern RXL_INTERFACE rxl_module1name;
 * extern RXL_INTERFACE rxl_module2name; etc
 *
 * This file is automatically generated during the build process. */
#include "rxllib.h"

/* Include the index of plugins.
 *
 * static rxl_plugins[] = {
 *	&rxl_module1name,
 *      &rxl_module2name, etc
 *      NULL };
 *
 * This file is automatically generated during the build process. */
#include "rxl.def"

static char szRegisteredModuleList[MAX_ATTRIBUTE_LEN];

/* rxlInitModules
 *
 * This function iterates through the list of compiled in modules, and calls
 * the registration function for each.  Modules which claim to initialise
 * correctly are added to the list of registered modules. */
void rxlInitModules()
{
    int i, l;
    
    szRegisteredModuleList[0] = '\0';
    
    for (i = l = 0; rxl_plugins[i] != NULL; i++) {
	
	if ((rxl_plugins[i]->rxlInitModule != NULL) &&
	    (rxl_plugins[i]->rxlInitModule() != 0)) {
	    
	    if (l + strlen(rxl_plugins[i]->rxlName) < MAX_ATTRIBUTE_LEN-1) {
		strcpy(&szRegisteredModuleList[l], 
		       rxl_plugins[i]->rxlName);
		rxl_plugins[i]->rxlNameLen =
		    strlen(rxl_plugins[i]->rxlName);
		
		l = l + strlen(rxl_plugins[i]->rxlName);
		szRegisteredModuleList[l++] = ' ';
	    }
	    
	}
    }
    
    /* Remove the trailing space from correctly registered modules */
    if (l != 0)
	szRegisteredModuleList[--l] = '\0';
}

/* rxlListRegisteredModules
 *
 * This function returns the list of modules which were registered correctly
 * when the server was started.  These are the only modules which will be
 * correctly recognized when objects define their shields. */
const char *rxlListRegisteredModules()
{
     return szRegisteredModuleList;
}

/*
 * This function returns the index for the coordinate scheme selected.
 * If the scheme is not found, -1 is returned.
 *
 * A simple linear search for the time being.
 */
int rxlLookup(const char *scheme)
{
    int id;
    
    if (scheme == NULL)
	return -1;

    for (id = 0; rxl_plugins[id] != NULL; id++) {
	if (strcmp(scheme, rxl_plugins[id]->rxlName) == 0)
	    return id;
    }

    return -1;
}

int rxlFormat(int id, char *buff, int maxlen, range_t range, int flags)
{
    /* Check for things that should never occur */
    assert(id == -1);

    return (rxl_plugins[id]->rxlFormatSz)(buff, maxlen, range, flags);
}
