/* v1.1
 *
 * output.c:  Output formatting code.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#ifndef _OUTPUT_H
#define _OUTPUT_H

typedef struct {
#ifdef DEBUG_SSTR
    int trap;         /* Debugging overflow/underflow check */
#endif
    size_t max;       /* Maximum allocated size of the string */
    size_t cur;       /* Current length of the string */
    char   str[1];    /* This is actually just the start of the array */
} SSTR;

SSTR* sstr_new(size_t length);
void sstr_free(SSTR *ps);
int sstr_cat(SSTR *ps, const char *str, size_t len);
int sstr_cat_sprintf(SSTR *ps, const char *fmt, ...);
int sstr_sprintf(SSTR *ps, const char *fmt, ...);
const char *sstr_str(const SSTR *ps);
size_t sstr_len(const SSTR *ps);

#endif
