/* v1.1
 *
 * dbint.h:  Database interface macros.  Based on platform.h calls.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#define dbrefBridge(x)		getLocation(x->dbref_bridge)
#define dbrefEngine(x)	      	getLocation(x->dbref_eng)

#define dbrefUser(x)		getDbrefByNumber(x, PSE_USER_DBREF)
#define dbrefData(x)	       	getDbrefByNumber(x, PSE_DATA_DBREF)

#define IsSpace(x)              isSpace(x)

#define INFO_CONTACT_STRING		"INFO_CONTACT_STRING"
#define INFO_SCAN_STRING		"INFO_SCAN_STRING"
#define EVENT_STARTUP			"EV_STARTUP"
#define EVENT_SHUTDOWN			"EV_SHUTDOWN"
#define EVENT_COMM_RECEIVED		"EV_COMM_RECEIVED"
#define EVENT_BAY_DOORS			"EV_BAY_DOORS"
#define EVENT_NEW_CONTACT		"EV_NEW_CONTACT"
#define EVENT_CONTACT_LOST		"EV_CONTACT_LOST"
#define EVENT_INSIDE_CRITICAL		"EV_INSIDE_CRITICAL"
#define EVENT_OUTSIDE_CRITICAL		"EV_OUTSIDE_CRITICAL"

#define EVENT_DOCKED			"EV_DOCKED"
#define EVENT_DOCKED_WITH		"EV_DOCKED_WITH"
#define EVENT_DOCKED_OTHER		"EV_DOCKED_OTHER"
#define EVENT_UNDOCKED			"EV_UNDOCKED"
#define EVENT_UNDOCKED_FROM		"EV_UNDOCKED_FROM"
#define EVENT_UNDOCKED_OTHER		"EV_UNDOCKED_OTHER"

#define EVENT_LANDED			"EV_LANDED"
#define EVENT_LANDED_ON			"EV_LANDED_ON"
#define EVENT_LANDED_OTHER		"EV_LANDED_OTHER"
#define EVENT_LAUNCHED			"EV_LAUNCHED"
#define EVENT_LAUNCHED_FROM		"EV_LAUNCHED_FROM"
#define EVENT_LAUNCHED_OTHER		"EV_LAUNCHED_OTHER"

#define EVENT_ORBITED			"EV_ORBITED"
#define EVENT_ORBITING			"EV_ORBITING"
#define EVENT_ORBITING_OTHER		"EV_ORBITING_OTHER"

#define EVENT_CLOAK_OTHER		"EV_CLOAK_OTHER"
#define EVENT_DECLOAK_OTHER		"EV_DECLOAK_OTHER"

#define EVENT_LOCK_FAILED		"EV_LOCK_FAILED"
#define EVLF_BAD_TARGET			0
#define EVLF_CANT_LOCK			1
#define EVLF_ALREADY_LOCKED	        2

#define EVENT_UNLOCK			"EV_UNLOCK"
#define EVUL_UNLOCKED			0
#define EVUL_ABORTED			1
#define EVUL_NOT_LOCKED			2

#define EVENT_LOCKED_ON			"EV_LOCKED_ON"
#define EVENT_LOCK_ACHIEVED		"EV_LOCK_ACHIEVED"
#define EVENT_ENEMY_LOCK_ACHIEVED	"EV_ENEMY_LOCK_ACHIEVED"
#define EVENT_LOCK_BROKEN		"EV_LOCK_BROKEN"
#define EVENT_ENEMY_LOCK_BROKEN		"EV_ENEMY_LOCK_BROKEN"
#define EVENT_LOCK_ABORTED              "EV_LOCK_ABORTED"
#define EVENT_ENEMY_LOCK_ABORTED        "EV_ENEMY_LOCK_ABORTED"

#define EVENT_TRACTOR_ON		"EV_TRACTOR_ON"
#define EVENT_TRACTOR_ON_OTHER		"EV_TRACTOR_ON_OTHER"
#define EVENT_TRACTOR_BROKEN		"EV_TRACTOR_BROKEN"
#define EVENT_ENEMY_TRACTOR_BROKEN	"EV_ENEMY_TRACTOR_BROKEN"
#define EVENT_TRACTOR_BROKEN_OTHER	"EV_TRACTOR_BROKEN_OTHER"

#define EVENT_TORPS_LOADED		"EV_TORPS_LOADED"
#define EVENT_TORPS_ARMED		"EV_TORPS_ARMED"
#define EVENT_GUNS_CHARGED		"EV_GUNS_CHARGED"

#define EVENT_ATTACKED			"EV_ATTACKED"
#define EVENT_ATTACKED_OTHER		"EV_ATTACKED_OTHER"
#define EVENT_DISABLED			"EV_DISABLED"
#define EVENT_DISABLED_OTHER		"EV_DISABLED_OTHER"
#define EVENT_DESTROYED		        "EV_DESTROYED"
#define EVENT_DESTROYED_OTHER		"EV_DESTROYED_OTHER"
#define EVENT_TAKE_DAMAGE		"EV_TAKE_DAMAGE"
#define EVENT_LOW_POWER			"EV_LOW_POWER"
#define EVENT_REACTOR_DRAIN		"EV_REACTOR_DRAIN"

#define EVENT_EXPLOSION			"EV_EXPLOSION"
#define EVENT_EXPLOSION_OTHER		"EV_EXPLOSION_OTHER"

#define EVENT_TIMER                     "EV_TIMER"

/* Object movement code */

#define	MOVE_POS_X			"MOVE_POS_X"
#define MOVE_POS_Y		        "MOVE_POS_Y"
#define MOVE_POS_Z			"MOVE_POS_Z"

#define MOVE_HEAD_BEARING		"MOVE_HEAD_BEARING"
#define MOVE_HEAD_ELEVATION		"MOVE_HEAD_ELEVATION"
#define MOVE_SPEED			"MOVE_SPEED"
#define MOVE_ROLL			"MOVE_ROLL"

#ifdef ENABLE_SHIELD_CLASSES

#define SHIELDCLASS_FLAGS		"SC_FLAGS"
#define SHIELDCLASS_DAMAGE_FACTOR	"SC_DAMAGE_FACTOR"
#define SHIELDCLASS_PASS_FACTOR		"SC_PASS_FACTOR"
#define SHIELDCLASS_VISIBILITY_FACTOR	"SC_VISIBILITY_FACTOR"

#define SHIELDARRAY_LAYER		"SAL_LAYER"

#endif

/* Misc config attributes */

#define CONFIG_CONSOLE_TYPES		"CF_CONSOLE_TYPES"
#define STATUS_SPACE			"ST_SPACE"
#define STATUS_DOCKED_AT		"ST_DOCKED_AT"
