/* v0.9
 *
 * scm.c:  Shield Class Module interface routines.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include "spaceconf.h"
#include "pseint.h"
#include "dbint.h"
#include "space.h"

/* Include the core shield class definitions for the plugin interface */
#include "scm/scm.h"

/* Include the interface structure definitions 
 *
 * extern SCM_INTERFACE scm_module1name;
 * extern SCM_INTERFACE scm_module2name; etc
 *
 * This file is automatically generated during the build process. */
#include "scmlib.h"

/* Include the index of plugins.
 *
 * static scm_plugins[] = {
 *		&scm_module1name,
 *      &scm_module2name, etc
 *      NULL };
 *
 * This file is automatically generated during the build process. */
#include "scm.def"

static char szRegisteredModuleList[MAX_ATTRIBUTE_LEN];

/* scmInitModules
 *
 * This function iterates through the list of compiled in modules, and calls
 * the registration function for each.  Modules which claim to initialise
 * correctly are added to the list of registered modules. */
void scmInitModules()
{
    int i, l;
    
    szRegisteredModuleList[0] = '\0';
    
    for (i = l = 0; scm_plugins[i] != NULL; i++) {
	
	if ((scm_plugins[i]->scmInitModule != NULL) &&
	    (scm_plugins[i]->scmInitModule() != 0)) {
	    
	    if (l + strlen(scm_plugins[i]->scmName) < MAX_ATTRIBUTE_LEN-1) {
		strcpy(&szRegisteredModuleList[l], 
		       scm_plugins[i]->scmName);
		scm_plugins[i]->scmNameLen =
		    strlen(scm_plugins[i]->scmName);
		
		l = l + strlen(scm_plugins[i]->scmName);
		szRegisteredModuleList[l++] = ' ';
	    }
	    
	}
    }
    
    /* Remove the trailing space from correctly registered modules */
    if (l != 0)
	szRegisteredModuleList[--l] = '\0';
}

/* scmListRegisteredModules
 *
 * This function returns the list of modules which were registered correctly
 * when the server was started.  These are the only modules which will be
 * correctly recognized when objects define their shields. */
const char *scmListRegisteredModules()
{
     return szRegisteredModuleList;
}

/* scmLoadLayer
 *
 * This function is called to initialise each layer of shielding for new
 * ship objects.  It is passed the dbref to the object which defines the
 * ship, and the contents of it's SHIELDARRAY_LAYER<n> attribute.
 *
 * The SHIELDARRAY_LAYER<n> contents are checked against the list of
 * registered shield modules, and if a match is found, the appropriate
 * loading routine is called. */
int scmLoadLayer(dbref data, SCLAYER *layer, const char *szModule)
{
    int i, len;
    const char *szData;
    
    /* Strip leading spaces - not that there should be any... */
    for (; *szModule == ' '; szModule++)
	;
    
    /* Calculate the length of the string */
    for (len = 0, szData=szModule; *szData && *szData != ' '; szData++, len++)
	;
    
    /* Skip any spaces before the data parameter */
    for (; *szData == ' '; szData++)
	;
    
    /* Look for a match. Should probably make this a hash table at some
     * point - but it may not be worth it as the number of plugins is never
     * likely to be very high.
     */
    for (i = 0; scm_plugins[i] != NULL; i++) {
	
	if ((len == scm_plugins[i]->scmNameLen) &&
	    (strncmp(scm_plugins[i]->scmName, szModule, len) == 0)) {
	    
	    return scm_plugins[i]->scmLoadLayer(data, layer, szData);
	}
    }
    
    return 0;
}
