/* v0.8
 *
 * sensors.h:  Sensor module header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

/* display_ship_data control words */
#define DSD_NEW                 0
#define DSD_UPDATE              1
#define DSD_ROUTINE             2
#define DSD_DETAILED            3

typedef struct distance_entry DISTENT;

struct distance_entry {

	TAG *object;
	int range;
/*	int width; */
	DISTENT *next;
	DISTENT *prev;

};

#define HubRange(pos)   (int) sqrt((double) pos.x*pos.x + (double) pos.y*pos.y + (double) pos.z*pos.z)

extern DISTENT *dist_table[]; 	/* Table containing all objects */

extern void snsBuildDistanceTables(int);
extern void snsFreeDistanceTables(int);
extern void snsCheckSensors(int);
extern CONTACT *snsFindContact(TAG *, TAG *);
extern CONTACT *snsFindContactByNumber(TAG *, int);
extern void snsRemoveContact(TAG *, TAG *, int);
extern void snsSenseObject(TAG *, TAG *);
extern void snsListContacts(char *, CONTACT *, int, int);
extern void snsScan(TAG *, dbref, int);
extern void snsDisplaySensorInfo(TAG *, CONTACT *, dbref, int);
extern void snsDisplayContacts(TAG *, dbref, int, int);
