/* v0.8
 *
 * platform.h:  MUD platform-specific macros and definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */ 

#define SPACE

#ifndef NULL
#define NULL 0
#endif

#if defined(MUX) || defined(MUSH)

#include <autoconf.h>
#include <config.h>
#include <db.h>
#include <interface.h>
#include <mudconf.h>
#include <command.h>
#include <functions.h>
#include <externs.h>
#include <match.h>
#include <attrs.h>
#include <flags.h>
#include <alloc.h>

#endif

/*
 * This is the prototype for MU* functions
 */

#ifdef MUX 
#define MUDFUNCTION(x)     \
void x(buff, bufc, player, cause, fargs, nfargs, cargs, ncargs) \
        char *buff, **bufc; \
        dbref player, cause; \
        char *fargs[], *cargs[]; \
        int nfargs, ncargs;
#else
#define MUDFUNCTION(x)     \
void x(buff, player, cause, fargs, nfargs, cargs, ncargs) \
        char *buff; \
        dbref player, cause; \
        char *fargs[], *cargs[]; \
        int nfargs, ncargs;
#endif
 
/* Define general names to correspond to arguments in the FUNCTION call.
 */

#if defined(MUX) || defined(MUSH)
#define Player		player
#define Cause		cause
#define NumArgs		nfargs
#define Args		fargs
#endif

/* 
 * Macros used by the space engine (to hide the mud internals)
 */

#ifdef MUX
#define Notify(x,y)		notify_with_cause(x, GOD, y)
#define NotifyExcept(w,x,y,z)	notify_except(w,x,y,z)
#define WriteFunctionBuffer(x)	safe_str(x, buff, bufc)
#define FWriteFunctionBuffer(x,y) safe_str(tprintf(x,y), buff, bufc)
#define AllocBuffer(x)		alloc_sbuf(x) /* Allocate small buffer */
#define FreeBuffer(x)		free_sbuf(x)
#define ValidObject(x)			validObject(x)

typedef void (*F_COMMAND)(void *, dbref, char **);
typedef void (*F_FUNCTION)(void *, char *, char **, dbref, char **);

#define CALL_COMMAND(fun, object, cause, args) \
	(*((F_COMMAND)fun))(object, cause, args)		

#define CALL_FUNCTION(fun, object, cause, args) \
	(*((F_FUNCTION)fun))(object, buff, bufc, cause, args)		

#endif

#ifdef MUSH
#define Notify(x,y)		notify_with_cause(x, GOD, y)
#define NotifyExcept(w,x,y,z)	notify_except(w,x,y,z)
#define WriteFunctionBuffer(x)	strcpy(buff, x)
#define FWriteFunctionBuffer(x,y) strcpy(buff, tprintf(x,y))
#define AllocBuffer(x)		alloc_sbuf(x) /* Allocate small buffer */
#define FreeBuffer(x)		free_sbuf(x)
#define ValidObject(x)			validObject(x)

typedef void (*F_COMMAND)(void *, dbref, char **);
typedef void (*F_FUNCTION)(void *, char *, dbref, char **);

#define CALL_COMMAND(fun, object, cause, args) \
	(*((F_COMMAND)fun))(object, cause, args)		

#define CALL_FUNCTION(fun, object, cause, args) \
	(*((F_FUNCTION)fun))(object, buff, cause, args)		

#endif

/*
 * General declarations and parameters
 */

extern char *getAttrByNumber(dbref, int);
extern char *getAttrByName(dbref, char *);
extern char *getEvalAttr(dbref, char *, char **, int);
extern void setAttrByNumber(dbref, int, char *);
extern void setAttrByName(dbref, char *, char *);
