/* v0.8
 *
 * dbint.h:  Database interface macros.  Based on platform.h calls.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#define getDbrefByNumber(x,y)   parseDbref(getAttrByNumber(x,y))
#define getDbrefByName(x,y)     parseDbref(getAttrByName(x,y))
#define dbrefBridge(x)		getLocation(x->nav)
#define dbrefEngine(x)		getLocation(x->eng)
#define dbrefUser(x)		getDbrefByNumber(x, A_USER_DBREF)
#define dbrefData(x)		getDbrefByNumber(x, A_DATA_DBREF)
#define getSpaceNumber(x)	atoi(getAttrByName(x, "ST_SPACE"))

/* Object configuration */

#define CONFIG_SIZE			"CF_SIZE"
#define CONFIG_XPORT_RANGE		"CF_XPORT_RANGE"
#define CONFIG_SENSOR_RANGE		"CF_SENSOR_RANGE"
#define CONFIG_CLOAK_EFFECT		"CF_CLOAK_EFFECT"
#define CONFIG_CRITICAL_RANGE		"CF_CRITICAL_RANGE"

/* Object status */

#define STATUS_SPACE			"ST_SPACE"
#define STATUS_STARTPOS			"ST_STARTPOS"
#define STATUS_FLAGS			"ST_FLAGS"

/* Object events */

#define INFO_CONTACT_STRING		"INFO_CONTACT_STRING"
#define INFO_SCAN_STRING		"INFO_SCAN_STRING"
#define EVENT_STARTUP			"EV_STARTUP"
#define EVENT_SHUTDOWN			"EV_SHUTDOWN"
#define EVENT_COMM_RECEIVED		"EV_COMM_RECEIVED"
#define EVENT_BAY_DOORS			"EV_BAY_DOORS"
#define EVENT_NEW_CONTACT		"EV_NEW_CONTACT"
#define EVENT_CONTACT_LOST		"EV_CONTACT_LOST"
#define EVENT_INSIDE_CRITICAL		"EV_INSIDE_CRITICAL"
#define EVENT_OUTSIDE_CRITICAL		"EV_OUTSIDE_CRITICAL"

#define EVENT_DOCKED			"EV_DOCKED"
#define EVENT_DOCKED_WITH		"EV_DOCKED_WITH"
#define EVENT_DOCKED_OTHER		"EV_DOCKED_OTHER"
#define EVENT_UNDOCKED			"EV_UNDOCKED"
#define EVENT_UNDOCKED_FROM		"EV_UNDOCKED_FROM"
#define EVENT_UNDOCKED_OTHER		"EV_UNDOCKED_OTHER"

#define EVENT_LANDED			"EV_LANDED"
#define EVENT_LANDED_ON			"EV_LANDED_ON"
#define EVENT_LANDED_OTHER		"EV_LANDED_OTHER"
#define EVENT_LAUNCHED			"EV_LAUNCHED"
#define EVENT_LAUNCHED_FROM		"EV_LAUNCHED_FROM"
#define EVENT_LAUNCHED_OTHER		"EV_LAUNCHED_OTHER"

#define EVENT_ORBITED			"EV_ORBITED"
#define EVENT_ORBITING			"EV_ORBITING"
#define EVENT_ORBITING_OTHER		"EV_ORBITING_OTHER"

#define EVENT_CLOAK_OTHER		"EV_CLOAK_OTHER"
#define EVENT_DECLOAK_OTHER		"EV_DECLOAK_OTHER"

#define EVENT_LOCKED_ON			"EV_LOCKED_ON"
#define EVENT_LOCK_ACHIEVED		"EV_LOCK_ACHIEVED"
#define EVENT_LOCK_BROKEN		"EV_LOCK_BROKEN"
#define EVENT_ENEMY_LOCK_BROKEN		"EV_ENEMY_LOCK_BROKEN"

#define EVENT_TRACTOR_ON		"EV_TRACTOR_ON"
#define EVENT_TRACTOR_ON_OTHER		"EV_TRACTOR_ON_OTHER"
#define EVENT_TRACTOR_BROKEN		"EV_TRACTOR_BROKEN"
#define EVENT_ENEMY_TRACTOR_BROKEN	"EV_ENEMY_TRACTOR_BROKEN"
#define EVENT_TRACTOR_BROKEN_OTHER	"EV_TRACTOR_BROKEN_OTHER"

#define EVENT_TORPS_LOADED		"EV_TORPS_LOADED"
#define EVENT_TORPS_ARMED		"EV_TORPS_ARMED"
#define EVENT_GUNS_CHARGED		"EV_GUNS_CHARGED"

#define EVENT_ATTACKED			"EV_ATTACKED"
#define EVENT_ATTACKED_OTHER		"EV_ATTACKED_OTHER"
#define EVENT_DISABLED			"EV_DISABLED"
#define EVENT_DISABLED_OTHER		"EV_DISABLED_OTHER"
#define EVENT_DESTROYED			"EV_DESTROYED"
#define EVENT_DESTROYED_OTHER		"EV_DESTROYED_OTHER"
#define EVENT_TAKE_DAMAGE		"EV_TAKE_DAMAGE"
#define EVENT_LOW_POWER			"EV_LOW_POWER"
#define EVENT_REACTOR_DRAIN		"EV_REACTOR_DRAIN"

#define EVENT_EXPLOSION			"EV_EXPLOSION"
#define EVENT_EXPLOSION_OTHER		"EV_EXPLOSION_OTHER"


/* Object movement code */

#define	MOVE_POS_X			"MOVE_POS_X"
#define MOVE_POS_Y			"MOVE_POS_Y" 
#define MOVE_POS_Z			"MOVE_POS_Z" 

#define MOVE_HEAD_BEARING		"MOVE_HEAD_BEARING"
#define MOVE_HEAD_ELEVATION		"MOVE_HEAD_ELEVATION"
#define MOVE_SPEED			"MOVE_SPEED"

/* Ship configuration */

#define CONFIG_CLASS			"CF_CLASS"
#define CONFIG_TYPE			"CF_TYPE"
#define CONFIG_OWNER_NAME		"CF_OWNER_NAME"
#define CONFIG_OWNER_NUM		"CF_OWNER_NUM"
#define CONFIG_HULL			"CF_HULL"
#define CONFIG_TRACTOR_STATUS		"CF_TRACTOR_STATUS"
#define CONFIG_TRACTOR_EFFECT		"CF_TRACTOR_EFFECT"
#define CONFIG_DOOR_STATUS		"CF_DOOR_STATUS"
#define CONFIG_DOOR_SIZE		"CF_DOOR_SIZE"
#define CONFIG_DOOR_SIDE		"CF_DOOR_SIDE"
#define CONFIG_REACTOR_OUTPUT   	"CF_REACTOR_OUTPUT"
#define CONFIG_REACTOR_OVER_POINTS  	"CF_REACTOR_OVER_POINTS"
#define CONFIG_REACTOR_LEVEL_STRESS  	"CF_REACTOR_LEVEL_STRESS"
#define CONFIG_REACTOR_LEVEL_NORMAL 	"CF_REACTOR_LEVEL_NORMAL"
#define CONFIG_REACTOR_OVER_PENALTY	"CF_REACTOR_OVER_PENALTY"
#define CONFIG_BATTS_CAPACITY		"CF_BATTS_CAPACITY"
#define CONFIG_BATTS_DISCHARGE		"CF_BATTS_DISCHARGE"
#define CONFIG_WARP_FACTOR		"CF_WARP_FACTOR"
#define CONFIG_WARP_MAX			"CF_WARP_MAX"
#define CONFIG_CLOAK_STATUS		"CF_CLOAK_STATUS"
#define CONFIG_CLOAK_COST		"CF_CLOAK_COST"
#define CONFIG_SCANNER_RANGE		"CF_SCANNER_RANGE"
#define CONFIG_COMM_RANGE		"CF_COMM_RANGE"
#define CONFIG_COMM_SENSITIVITY		"CF_COMM_SENSITIVITY"
#define CONFIG_SHIELD_FACTOR		"CF_SHIELD_FACTOR"
#define CONFIG_SHIELD_POWER		"CF_SHIELD_POWER"
#define CONFIG_SHIELD_CHARGE_RATE	"CF_SHIELD_CHARGE_RATE"
#define CONFIG_GUN_NAME			"CF_GUN_NAME"
#define CONFIG_GUN_QTY			"CF_GUN_QTY"
#define CONFIG_GUN_POWER		"CF_GUN_POWER"
#define CONFIG_GUN_RANGE		"CF_GUN_RANGE"
#define CONFIG_GUN_DELIVERY		"CF_GUN_DELIVERY"
#define CONFIG_GUN_CHARGE_RATE		"CF_GUN_CHARGE_RATE"
#define CONFIG_TORP_LOADERS		"CF_TORP_LOADERS"
#define CONFIG_TORP_NAME		"CF_TORP_NAME"
#define CONFIG_TORP_QTY			"CF_TORP_QTY"
#define CONFIG_TORP_POWER		"CF_TORP_POWER"
#define CONFIG_TORP_RANGE		"CF_TORP_RANGE"
#define CONFIG_TORP_CHARGE_RATE		"CF_TORP_CHARGE_RATE"
#define CONFIG_TORP_ACCURACY		"CF_TORP_ACCURACY"
#define CONFIG_TORP_AMMO		"CF_TORP_AMMO"
#define CONFIG_DAMCON_TEAMS		"CF_DAMCON_TEAMS"

#define CONFIG_DBREF_TACTICAL		"CF_DBREF_TACTICAL"
#define CONFIG_DBREF_SHIELDS		"CF_DBREF_SHIELDS"
#define CONFIG_DBREF_NAV		"CF_DBREF_NAV"
#define CONFIG_DBREF_ENG		"CF_DBREF_ENG"
#define CONFIG_DBREF_XPORT		"CF_DBREF_XPORT"
#define CONFIG_DBREF_COMM		"CF_DBREF_COMM"
#define CONFIG_DBREF_DAMCON		"CF_DBREF_DAMCON"

/* Ship status */

#define STATUS_HULL_DAMAGE		"ST_HULL_DAMAGE"
#define STATUS_SYSTEM_DAMAGE		"ST_SYSTEM_DAMAGE"
#define STATUS_SHIPFLAGS		"ST_SHIPFLAGS"
#define STATUS_DOCKED_AT		"ST_DOCKED_AT"

